using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents all VistALink protocol 
	/// security request messages.
	/// </summary>
	public abstract class SecurityBaseRequestMessage : BaseRequestMessage
	{
		/// <summary>
		/// VistALink message type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string MessageType = "gov.va.med.foundations.security.request";

		/// <summary>
		/// Contstructor specifying minimal required VistALink security request message parameters. 
		/// </summary>
		/// <param name="sourceXSD">VistALink message XSD name</param>
		/// <param name="requestType">Request message type. </param>
		protected SecurityBaseRequestMessage( string sourceXSD, string requestType ) 
			: base( MessageType, sourceXSD, requestType ) {}

		/// <summary>
		/// Constructor extending standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceXSD">VistALink message XSD name</param>
		/// <param name="requestType">VistALink request message type</param>
		/// <param name="sourceDoc">Source XML document</param>
		protected SecurityBaseRequestMessage( string sourceXSD, string requestType, XmlDocument sourceDoc ) 
			: base( MessageType, sourceXSD, requestType, sourceDoc ) 
		{
			SecurityMessageImplementationMixin.ParseCommonSecurityXmlContent( sourceDoc );
		}

		/// <summary>
		/// Standard VistALink message XML serialization method, 
		/// translating message object into XML representation.
		/// </summary>
		/// <param name="writer">XmlWriter object to use for serialization.</param>
		protected override void WriteXmlMessageBody( XmlWriter writer )
		{
			SecurityMessageImplementationMixin.WriteCommonSecurityXmlContent( writer );
			base.WriteXmlMessageBody( writer );
		}
	}
}
